﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CashierCrisis.Entities
{
    public class EntityPool
    {
        private Stack<Entity> _entities;

        public EntityPool(int capacity)
        {
            _entities = new Stack<Entity>();

            for (int i = 0; i < capacity; i++)
            {
                Entity entity = new Entity();
                entity.Pool = this;
                _entities.Push(entity);
            }
        }

        public Entity Fetch()
        {
            Entity entity = _entities.Pop();
            return entity;
        }

        public void Return(Entity entity)
        {
            _entities.Push(entity);
        }

        public int Count
        {
            get
            {
                return _entities.Count;
            }
        }
    }
}
